/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
 * Definitions associated with packets in MX TCP
 */

struct mx_pkt_hdr {
  uint32_t type;		/* type of packet */
  mx_endpoint_addr_t source;	/* address of sender */
  uint32_t length;		/* length excluding header */
};

/*
 * MX packet types
 */
enum mx_pkt_type
{
    MX_PKT_TYPE_CONN,		/* establish connection */
    MX_PKT_TYPE_SEND,		/* standard send */
    MX_PKT_TYPE_ISSEND,
    MX_PKT_TYPE_ISSEND_ACK,
    MX_PKT_TYPE_BARRIER,	/* barrier */
    MX_PKT_TYPE_BCAST,		/* broadcat */
    MX_PKT_TYPE_BARRIER_ACK,
    MX_PKT_TYPE_PUT,
    MX_PKT_TYPE_PUT_ACK,
    MX_PKT_TYPE_GET,
    MX_PKT_TYPE_GET_DATA
};
typedef enum mx_pkt_type mx_pkt_type_t;

/*
 * Secondary header for a send
 */

struct mx_send_hdr {
  uint32_t match_a;
  uint64_t match_b;
  mx_request_t request;
  uint32_t rdma_handle;         /* for RDMA write */
  uint32_t rdma_offset;         /* for RDMA write */
  uint32_t rdma_status;           /* for RDMA read */
};

/* packet.c */
int mx_send_header(int s, mx_pkt_type_t, struct mx_endpoint *, uint32_t);
